#ifndef DAG_HPP
#define DAG_HPP

#include <vector>
#include <unordered_set>
#include <utility>
#include <unordered_map>

class DirectedAcyclicGraph {
private:
    int n;                               
    int m;
    int MAXEDGE;
    std::vector<std::vector<int>> DAG;
    std::vector<std::vector<int>> DAG_R;
    std::vector<int> indegree;
    std::vector<int> indegree_r;
    std::vector<std::pair<int, int>> edges;
    static int comparison_count_sort;
    

public:
    std::unordered_map<int, int> labelToindex;
    std::vector<int> indexTolabel;

    DirectedAcyclicGraph(int numNodes, int numEdges);
    static bool custom_compare(const int& a, const int& b);

    void BuildCompleteDAG();
    std::vector<std::vector<int>> GreedyChainDecomposition();
    std::vector<std::vector<int>> ChainDecomposition(const std::vector<int>& match, const std::vector<int>& inv_match);
    void Reachable(int x, std::unordered_set<int>& left, std::unordered_set<int>& right, const std::vector<bool>& active) const;

    std::vector<int> Median(std::vector<bool>& active, std::vector<bool>&local_active) const;

    const std::vector<std::vector<int>>& GetDAG() const;
    const std::vector<std::vector<int>>& GetDAG_R() const;
    const std::vector<std::pair<int, int>>& GetEdges() const;
    const std::vector<int>& GetIndegree() const;
    const std::vector<int>& GetIndegreeR() const;
    const std::vector<int> GetindexTolabel()const ;
    int GetMaxEdge() const;
    int GetNumNodes() const;
    int GetNumEdges() const;
    int GetComparisonCountSort() const;
};

#endif
